<?php
// Include the Composer autoload file
//require 'vendor/autoload.php';

// Use ZXing QrReader
//use Zxing\QrReader;

// Initialize the variable for displaying the result
$qrCodeData = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['qrCodeImage'])) {
    // Get the uploaded file details
    $uploadedFile = $_FILES['qrCodeImage'];

    // Check for errors in the upload
    if ($uploadedFile['error'] == 0) {
        $fileTmpPath = $uploadedFile['tmp_name'];
        
        // Create a new instance of QrReader to decode the QR code
        try {
            $qrReader = new QrReader($fileTmpPath);
            $qrCodeData = $qrReader->decode();
        } catch (Exception $e) {
            $qrCodeData = 'Error reading the QR code: ' . $e->getMessage();
        }
    } else {
        $qrCodeData = 'Error uploading the file.';
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>QR Code Reader</title>
</head>
<body>
    <h1>QR Code Reader</h1>
    
    <!-- Form for uploading the QR Code image -->
    <form method="POST" enctype="multipart/form-data">
        <label for="qrCodeImage">Upload QR Code Image:</label>
        <input type="file" name="qrCodeImage" id="qrCodeImage" accept="image/*" required>
        <button type="submit">Upload and Read</button>
    </form>
    
    <?php if (!empty($qrCodeData)): ?>
        <h2>QR Code Data:</h2>
        <p><?php echo htmlspecialchars($qrCodeData); ?></p>
    <?php endif; ?>
</body>
</html>
